function hs=panel3(p)
timestart=datestr(p.start_time,'mm/dd/yy HH:MM:SS');
ind=find(p.turb<1.);
hs=figure('Name',['Wind Profiles for  ',timestart],'Position',[50 50 1400 800]);

subplot(1,3,1)

p1=scatter(p.Vh(ind),p.heights(ind));

ylabel('Height AGL (m)','FontSize',14)
xlabel('Horizontal Wind Speed (m/s)','FontSize',14)


subplot(1,3,2)
p2=scatter(p.theta(ind),p.heights(ind));
xlim([0 360])
set(gca,'Xtick',[0,90,180,270,360])
xlabel('Wind Direction (degrees)','FontSize',14)
ht=title(['Wind Profile for  ',timestart])


subplot(1,3,3)
p2=scatter(p.w(ind),p.heights(ind));
xlim([-5 5])
set(gca,'Xtick',[-5,-2.5,0,2.5,5])
xlabel('Vertical Wind (m/s)','FontSize',14)


end